@php
    // foreach ($drivers as $driver) {
    //     printf('Found subcollection with id: %s' . PHP_EOL, $driver->id());
    // }

    // var_dump(auth()->user()->name);
    // die;
@endphp

@extends('main-layout')

@section('container')
    

    <div class="nav-scroller bg-body shadow-sm">
    </div>

    <main class="container-fluid">
        <div class="row p-5 my-2">
            <div class="col-2 my-3 mx-1 p-3 bg-body rounded shadow-sm">
                <h6 class="border-bottom pb-2 mb-0">Driver List</h6>
                    <div class="list-group my-2">
                        @foreach ($drivers as $driver)                            
                            <a href="#" class="list-group-item list-group-item-action get-data" data-id="{{ $driver->id() }}" >{{ $driver->id() }}</a>
                        @endforeach
                    </div>
            </div>
            <div class="col-2 my-3 mx-1 p-3 bg-body rounded shadow-sm" id="jobs"></div>
            <div class="col-2 my-3 mx-1 p-3 bg-body rounded shadow-sm" id="trips"></div> 
            <div class="col my-3 mx-1 p-3 bg-body rounded shadow-sm" id="trip_details"></div>     
        </div>
    </main>


        <!-- JavaScript Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/js/bootstrap.bundle.min.js" integrity="sha384-pprn3073KE6tl6bjs2QrFaJGz5/SUsLqktiwsUTF55Jfv3qYSDhgCecCxMW52nD2" crossorigin="anonymous"></script>

    <script>
        $(document).on("click", ".get-data", function(){
            const id = this.getAttribute("data-id");
            console.log(id)
            $.ajax({
                type: 'GET', 
                url: '/get-jobs/'+ id,
                dataType: 'json',
                success: function (data) {  
                    console.log(data.jobs)

                    let jobs_list = ''

                    data.jobs.forEach(element => {
                        jobs_list += "<a href='#' class='list-group-item list-group-item-action get-jobs-data' data-did='"+ id +"' data-tid='"+ element +"'>"+ element +"</a>"
                    });

                    const jobs_list_container = `<h6 class="border-bottom pb-2 mb-0">Jobs List</h6>
                                                <div class="list-group my-2">
                                                    ${jobs_list}
                                                </div>`

                    $("#trip_details").empty()
                    $("#trips").empty()
                    $("#jobs").empty()
                    $('#jobs').append(jobs_list_container)  
                },
                error:function(data){ 
                    console.log(data);
                }
            });
        }); 

        $(document).on("click", ".get-jobs-data", function(){
            const tid = this.getAttribute("data-tid");
            const did = this.getAttribute("data-did");

            console.log(did, tid)

            $.ajax({
                type: 'GET', 
                url: '/get-trips/'+ did + '/' + tid,
                dataType: 'json',
                success: function (data) {  
                    console.log(data.trip_details)

                    let trips_list = ''

                    data.trip_details.forEach(element => {
                        trips_list += "<a href='#' class='list-group-item list-group-item-action get-trips-data' data-did='"+ did +"' data-tid='"+ tid +"' data-detailid='"+ element +"'>"+ element +"</a>"
                    });

                    const trips_detail_container = `<h6 class="border-bottom pb-2 mb-0">Raids List</h6>
                                                <div class="list-group my-2">
                                                    ${trips_list}
                                                </div>`

                    $("#trip_details").empty()
                    $("#trips").empty()
                    $('#trips').append(trips_detail_container)  

                },
                error:function(data){ 
                    console.log(data);
                }
            });
        }); 

        $(document).on("click", ".get-trips-data", function(){
            const tid = this.getAttribute("data-tid");
            const did = this.getAttribute("data-did");
            const detailid = this.getAttribute("data-detailid");

            console.log(did, tid, detailid)

            $.ajax({
                type: 'GET', 
                url: '/get-trip-details/'+ did + '/' + tid + '/' + detailid,
                dataType: 'json',
                success: function (data) {  
                    console.log(data.details.date)

                    const trips_detail_container = `<h6 class="border-bottom pb-2 mb-0">Raid Details</h6>
                                                    <div class="list-group my-2">
                                                        <ul class="list-group">
                                                            <li class="list-group-item"><strong>Date: </strong> ${data.details.date} </li>
                                                            <li class="list-group-item"><strong>From: </strong> ${data.details.from} </li>
                                                            <li class="list-group-item"><strong>To: </strong> ${data.details.to} </li>
                                                        </ul>
                                                    </div>`

                    $("#trip_details").empty()
                    $('#trip_details').append(trips_detail_container)  

                },
                error:function(data){ 
                    console.log(data);
                }
            });
        }); 
    </script>

@endsection
  
