<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect('login');
});

Route::get('/list-drivers', function () {
    $drivers = app('firebase.firestore')->database()->collection('Drivers')->document('Alldrivers')->collections();
    // var_dump("<pre>", $drivers);

    foreach ($drivers as $collection) {
        var_dump("<pre>", $collection->data());
        // printf('Found subcollection with id: %s' . PHP_EOL, $collection->id());
    }

    // foreach ($drivers->documents() as $document) {
    //     if ($document->exists()) {
    //         printf('Document data for document %s:' . PHP_EOL, $document->id());
    //         print_r($document->data());
    //         printf(PHP_EOL);
    //     } else {
    //         printf('Document %s does not exist!' . PHP_EOL, $document->id());
    //     }
    // }

    die;
});

//Current Location
Route::get('/current-location', function () {
    $drivers = app('firebase.firestore')->database()->collection('Drivers')->document('Alldrivers')->collections();
    return view('dashboard', compact('drivers'));
})->middleware(['auth'])->name('current-location');

Route::get('/get-location/{id}', function ($id) {
    $location = app('firebase.firestore')->database()->collection('Drivers')->document('Alldrivers')->collection($id)->document('location')->snapshot();
    return response()->json(['location' => $location->data()]);
})->middleware(['auth'])->name('get-location');

// Jobs
Route::get('/jobs', function () {
    $drivers = app('firebase.firestore')->database()->collection('Drivers')->document('Alldrivers')->collections();
    return view('jobs', compact('drivers'));
})->middleware(['auth'])->name('jobs');

Route::get('/get-jobs/{id}', function ($id) {
    $jobs = app('firebase.firestore')->database()->collection('Drivers')->document('Alldrivers')->collection($id)->document('Jobs')->collections();
    $jobs_id = [];

    foreach ($jobs as $job) {
        array_push($jobs_id, $job->id());
    }

    return response()->json(['jobs' => $jobs_id]);
})->middleware(['auth'])->name('get-jobs');

Route::get('/get-trips/{did}/{tid}', function ($did, $tid) {
    $trips = app('firebase.firestore')->database()->collection('Drivers')->document('Alldrivers')->collection($did)->document('Jobs')->collection($tid)->documents();
    $trip_details_id = [];

    foreach ($trips as $trip) {
        array_push($trip_details_id, $trip->id());
    }

    return response()->json(['trip_details' => $trip_details_id]);
})->middleware(['auth'])->name('get-trips');

Route::get('/get-trip-details/{did}/{tid}/{detailid}', function ($did, $tid, $detailid) {
    $trip_details = app('firebase.firestore')->database()->collection('Drivers')->document('Alldrivers')->collection($did)->document('Jobs')->collection($tid)->document($detailid)->snapshot();
    
    $details = [];
    foreach($trip_details->data() as $key => $data)
    {
        if(is_object($data))
        {
            $details[$key] = $data->formatAsString();
        }
        else
        {
            $details[$key] = $data;
        }
    }
    
    
    return response()->json(['details' => $details]);
})->middleware(['auth'])->name('get-trip-details');


require __DIR__ . '/auth.php';
